let showEllipses = true; // Variable to toggle between patterns
let unit = 50; // Size of the unit for herringbone lines
let lastColorChange = 0; // Variable to track the last time the color changed
let colorChangeInterval = 500; // Time interval for changing color (500ms = 0.5 seconds)

function setup() {
  createCanvas(600,600); // Fullscreen canvas
  noStroke(); // Remove stroke for cleaner ellipses
}

function draw() {
  background(0);
  if (showEllipses) {
    drawEllipses();
  } else {
    drawHerringbone();
  }
}

function drawEllipses() {
  let currentTime = millis();
  // Change color every 0.5 seconds
  if (currentTime - lastColorChange > colorChangeInterval) {
    lastColorChange = currentTime; // Update the time of last color change
  }
  
  fill(random(255), random(255), random(255)); // Change the fill color randomly every 0.5 seconds
  
  let x = 25;
  while (x < width) {
    let y = 25;
    while (y < height) {
      ellipse(x, y, 50, 50);
      y += 50;
    }
    x += 50;
  }
}

function drawHerringbone() {
  stroke(255);
  strokeWeight(1);

  let xVal = unit;
  let yVal = unit;
  while (yVal < height) {
    while (xVal < width) {
      herringBone(xVal, yVal, unit);
      xVal += unit * 2; // Space out the herringbone pattern
    }
    xVal = unit; // Reset x position for next row
    yVal += unit * 2; // Move down for the next row
  }
}

function herringBone(xVal, yVal, unit) {
  line(xVal, yVal, xVal - unit, yVal + unit);
  line(xVal, yVal, xVal + unit, yVal + unit);
  line(xVal, yVal - unit, xVal - unit, yVal);
  line(xVal, yVal - unit, xVal + unit, yVal);
  line(xVal, yVal - unit, xVal, yVal + unit);
  line(xVal + unit, yVal - unit, xVal + unit, yVal + unit);
}

// Toggle between ellipses and herringbone when the spacebar is pressed
function keyPressed() {
  if (key === ' ') { // Spacebar to toggle
    showEllipses = !showEllipses; // Toggle the state
    redraw(); // Redraw the canvas with the new pattern
  }
}
